package fips.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


/** Own log manager, that uses private loggers. This makes
 *  the logmanager usable in an applet or webstart
 *  environment.
 */


public class LogManager {

  private static Hashtable	loggers;


  private static void init() {
    if(loggers==null) {
      loggers=new Hashtable();
      Logger logger=Logger.getAnonymousLogger();

      try {
        Handler ch=new java.util.logging.ConsoleHandler();
        ch.setLevel(Level.ALL);
        logger.addHandler(ch);
        logger.setUseParentHandlers(false);
      } catch (Exception e) {
        logger.log(Level.SEVERE,
                   "Failed to configure handlers for base logger", e);
      }

      loggers.put("", logger);
    }
  }

  public static Logger getLogger(String name) {
    init();

    Logger logger=(Logger)loggers.get(name);
    if(logger!=null) return(logger);

    logger=Logger.getAnonymousLogger();

// search for parents
    String bestkey=null;
    int bestlen=-1;
    Enumeration enum=loggers.keys();
    while(enum.hasMoreElements()) {
      String key=(String)enum.nextElement();
      if((name.startsWith(key))&&(key.length()>bestlen)) {
        bestkey=key;
        bestlen=key.length();
      }
    }
    if(bestkey!=null) {
      Logger parent=(Logger)loggers.get(bestkey);
      try {
        logger.setLevel(parent.getLevel());
        logger.setParent(parent);
      } catch (Exception e) {
        logger.log(Level.SEVERE, "Failed to configure child logger", e);
      }
    }

    loggers.put(name, logger);

    //ERROR ("#: no up-tree check yet");

    return(logger);
  }


  public static void setLogLevel(Level level, String pattern) {
    init();

    Enumeration enum=loggers.keys();

    Matcher matcher=Pattern.compile(pattern).matcher(pattern);

    while(enum.hasMoreElements()) {
      String key=(String)enum.nextElement();
      matcher.reset(key);
      if(matcher.matches()) {
        ((Logger)loggers.get(key)).setLevel(level);
      }
    }
  }


}



