package fips.game.jchess;

import java.util.Hashtable;
import java.util.logging.Level;

import fips.util.LogManager;

public class JChess {

  public static void main(String argv[]) {

// read the command line settings
    Hashtable params=new Hashtable();
    for(int i=0; i<argv.length; i++) {
      int f=argv[i].indexOf('=');
      if(f<0) {
        System.err.println("Only name=value arguments allowed");
        System.exit(1);
      }
      params.put(argv[i].substring(0, f), argv[i].substring(f+1));
    }

/*
    java.util.logging.Handler handlers[]=
       LogManager.getLogger("").getHandlers();
    //ERROR ("#: modifying "+handlers.length+" handlers");
    for(int i=0; i<handlers.length; i++) {
      handlers[i].setLevel(Level.ALL);
    }
*/

    LogManager.getLogger("jchess.Board").setLevel(Level.ALL);
    LogManager.getLogger("jchess.BoardGUI").setLevel(Level.INFO);
    LogManager.getLogger("jchess.ChessGUI").setLevel(Level.ALL);
    LogManager.getLogger("jchess.ChessEngine").setLevel(Level.ALL);

// create the new GUI

    ChessGUI cg = new ChessGUI(params);
  }
}
