package fips.game.jchess;

import java.awt.event.ActionEvent;

import java.util.Hashtable;
import java.util.logging.Logger;

import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

/** Complete GUI of the chess application. The gui of the board
 *  is a seperate component within this object. It also implements
 *  move listener to get an event when the opposite player or
 *  engine has moved.
 *
 *  The gui has 3 states:
 *     setup (edit position)
 *     wait start (before first move)
 *     play ()
 *
 *  If game end, state wait start entered
 *
 */
public class ChessGUI extends JFrame implements BoardMouseListener, Player {

  Board		board;

  BoardGUI	bgui;



/** True if white player is human.
 */
  boolean	iswhitehuman;
  boolean	isblackhuman;


  private final static int	STATE_SETUP=0;
/** Setup complete, wait for game start.
 */
  private final static int	STATE_WAIT=1;
  private final static int	STATE_PLAY=2;
  private final static int	STATE_END=3;

  int		state;

  Logger			logger;



  public ChessGUI(Hashtable params) {
    super("Roman's JChess Version @version@");

    logger=fips.util.LogManager.getLogger("jchess.ChessGUI");

    board = new Board();
    board.addBoardListener(this);

    iswhitehuman=true; isblackhuman=true;

    String str=(String)params.get("engine");
    if((str==null)||(str.equals("black"))) isblackhuman=false;
    else if(str.equals("white"))  iswhitehuman=false;
    else if(str.equals("both")) {
      iswhitehuman=false; isblackhuman=false;
    } else if(str.equals("none")) {
    } else throw new IllegalArgumentException();

    board.setPlayer(iswhitehuman?((Player)this):((Player)createEngine(params)),
                    ChessDefs.WHITE);
    board.setPlayer(isblackhuman?((Player)this):((Player)createEngine(params)),
                    ChessDefs.BLACK);

    board.addBoardListener(this);

    bgui=new BoardGUI("/fips/game/jchess/images", board);
    bgui.setEditable(false);
    bgui.addBoardMouseListener(this);
    getContentPane().add(bgui);

    javax.swing.JMenuBar bar=new javax.swing.JMenuBar();

    JMenu men=new JMenu("Options");
    men.add(new JMenuItem(new AbstractAction("Toggle View") {
      public void actionPerformed(ActionEvent e) {
        bgui.setView(bgui.getView()^ChessDefs.COLOR);
        logger.fine("Changed view to "+bgui.getView());
      }
    }));

    bar.add(men);

    setJMenuBar(bar);


    pack();
    setVisible(true);

    state=-1;
    setState(STATE_WAIT);


  }


  public void setState(int newstate) {
    logger.fine(".setState(newstate="+newstate+"), old="+state);
    if(newstate==state) return;

    switch(newstate) {
      case STATE_WAIT:
        bgui.setPlayMode(true);
        boolean ishuman;
        ishuman=(board.getMover()==ChessDefs.WHITE)?iswhitehuman:isblackhuman;
        bgui.setEditable(ishuman);
        if(ishuman) break;
        newstate=STATE_PLAY;
// enter state begin play
      case STATE_PLAY:
        board.start();
        break;
      default:
        throw new IllegalArgumentException("Illegal state "+state);
    }
    state=newstate;
  }


/** MoveListener implementation to get event when board changed
 */
  public void boardChanged(Board board) {
  }



  public void sit(Board b, int color) {
  }



  public void fieldClicked(int pos) {
  }


  public boolean pieceDragged(int from, int to) {
    if(!((board.getMover()==ChessDefs.WHITE)?iswhitehuman:isblackhuman)) {
      logger.severe("Piece dragged from wrong user, should not happen");
      return(false);
    }

    switch(state) {
      case STATE_WAIT:
        setState(STATE_PLAY);
      case STATE_PLAY:
        try {
          int data[]=board.getData();
          int np=0;
          if(((data[from]&ChessDefs.PIECE)==ChessDefs.PAWN)&&
             (((to>>3)==0)||((to>>3)==7))) {
            logger.severe("No piece dialog yet");
            np=ChessDefs.QUEEN;
          }

          board.makeMove(this, new Move(from, to, np));
          return(true);
        } catch (IllegalArgumentException ia) {
          logger.fine("Move was invalid: "+ia);
        }
        break;
      default:
        logger.severe("No state impl for "+state);
    }

    return(false);
  }



//************************
//
//			Private glue
//
//***********************


  private ChessEngine createEngine(Hashtable params) {
    return(new ChessEngine());
  }

}





