package fips.game.jchess;

public class ChessDefs {
  public final static int EMPTY		=  0x0;
  public final static int PAWN		=  0x1;
  public final static int BISHOP	=  0x2;
  public final static int KNIGHT	=  0x3;
  public final static int ROOK		=  0x4;
  public final static int QUEEN		=  0x5;
  public final static int KING		=  0x6;
  public final static int PIECE		=  0x7;

  public final static int MOVED		= 0x10;
  public final static int MOVED2	= 0x20;

  public final static int WHITE		= 0x00;
  public final static int BLACK		= 0x80;
  public final static int COLOR		= 0x80;









/** Check if a given field at pos is attacked by any piece of
 *  color.
 *  @param color the color of the attacker
 */
  public static boolean isAttacked(int pos, int board[], int color) {
    int tpos, i, j, k;

    if((board[pos]!=0)&&((board[pos]&COLOR)==color)) return(false);

    for(tpos=0; tpos<64; tpos++) {
      if((tpos==pos)||(board[tpos]==0)||
         ((board[tpos]&COLOR)!=color)) continue;

      switch(board[tpos]&PIECE) {
        case PAWN:
          i=(tpos&0x7)-(pos&0x7);
          j=(tpos>>3)-(pos>>3);

          if(((i!=-1)&&(i!=1))||((j!=-1)&&(j!=1))) break;

          if(color==WHITE) {
            if(j==-1) return(true);
          } else {
            if(j==1) return(true);
          }
          break;
        case BISHOP:
          i=(tpos&0x7)-(pos&0x7);
          j=(tpos>>3)-(pos>>3);
          if((i!=j)&&(i!=-j)) break;
// check if way is free
          k=pos;
          while(true) {
            k+=((i>0)?1:-1);
            k+=((j>0)?8:-8);
            if(k==tpos) return(true);
            if(board[k]!=0) break;
          }
          break;


// knight may attack if dx,dy is 1,2 or 2,1
        case KNIGHT:
          i=(tpos&0x7)-(pos&0x7);
          j=(tpos>>3)-(pos>>3);
          if(i<0) i=-i;
          if(j<0) j=-j;
          if((i+j==3)&&(i*j==2)) return(true);
          break;

// rook may attack if x,y of pos,tpos are the same
        case ROOK:
          if(((pos&0x7)!=(tpos&0x7))&&((pos&0x38)!=(tpos&0x38))) break;

// check if way is free
          if((pos&0x38)==(tpos&0x38)) {
            i=pos;
            while(true) {
              i+=((pos<tpos)?1:-1);
              if(i==tpos) return(true);
              if(board[i]!=0) break;
            }
          } else {
            i=pos;
            while(true) {
              i+=((pos<tpos)?8:-8);
              if(i==tpos) return(true);
              if(board[i]!=0) break;
            }
          }
          break;


        case QUEEN:
          i=(tpos&0x7)-(pos&0x7);
          j=(tpos>>3)-(pos>>3);
          if((i==j)||(i==-j)) {
// check if way is free
            k=pos;
            while(true) {
              k+=((i>0)?1:-1);
              k+=((j>0)?8:-8);
              if(k==tpos) return(true);
              if(board[k]!=0) break;
            }
            break;
          }
          if((i!=0)&&(j!=0)) break;
// check if way is free
          i=((i<0)?-1 : ((i>0)?1:0) );
          j=((j<0)?-8 : ((j>0)?8:0) );
          k=pos;
          while(true) {
            k+=i+j;
            if(k==tpos) return(true);
            if(board[k]!=0) break;
          }
          break;


        case KING:
          i=(tpos&0x7)-(pos&0x7);
          j=(tpos>>3)-(pos>>3);
          if((i>=-1)&&(i<=1)&&(j>=-1)&&(j<=1)) return(true);
          break;
        default:
          throw new InternalError("Piece "+(board[tpos]&PIECE)+
                                  " not implemented");
      }
    }

    return(false);
  }


}



