package fips.game.jchess;

/** Specialized mouse listener for the board component. The
 *  board gui notifies the listeners if pieces were clicked,
 *  dragged moved, etc.
 */

public interface BoardMouseListener {

  public void fieldClicked(int field);

/** If all listeners return true, then the BoardGUI will
 *  keep the piece at the position, where it was dragged
 *  to.
 */
  public boolean pieceDragged(int from, int to);

}


