/*
 * Decompiled with CFR 0.152.
 */
package fips.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogManager {
    private static Hashtable loggers;

    private static void init() {
        if (loggers == null) {
            loggers = new Hashtable();
            Logger logger = Logger.getAnonymousLogger();
            try {
                ConsoleHandler ch = new ConsoleHandler();
                ch.setLevel(Level.ALL);
                logger.addHandler(ch);
                logger.setUseParentHandlers(false);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to configure handlers for base logger", e);
            }
            loggers.put("", logger);
        }
    }

    public static Logger getLogger(String name) {
        LogManager.init();
        Logger logger = (Logger)loggers.get(name);
        if (logger != null) {
            return logger;
        }
        logger = Logger.getAnonymousLogger();
        String bestkey = null;
        int bestlen = -1;
        Enumeration enumeration = loggers.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!name.startsWith(key) || key.length() <= bestlen) continue;
            bestkey = key;
            bestlen = key.length();
        }
        if (bestkey != null) {
            Logger parent = (Logger)loggers.get(bestkey);
            try {
                logger.setLevel(parent.getLevel());
                logger.setParent(parent);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to configure child logger", e);
            }
        }
        loggers.put(name, logger);
        System.err.println("ERROR\tfips.util.LogManager#74: no up-tree check yet");
        return logger;
    }

    public static void setLogLevel(Level level, String pattern) {
        LogManager.init();
        Enumeration enumeration = loggers.keys();
        Matcher matcher = Pattern.compile(pattern).matcher(pattern);
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            matcher.reset(key);
            if (!matcher.matches()) continue;
            ((Logger)loggers.get(key)).setLevel(level);
        }
    }
}

