/*
 * Decompiled with CFR 0.152.
 */
package fips.game.jchess;

import fips.game.jchess.Board;
import fips.game.jchess.BoardGUI;
import fips.game.jchess.BoardMouseListener;
import fips.game.jchess.ChessEngine;
import fips.game.jchess.Move;
import fips.game.jchess.Player;
import fips.util.LogManager;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class ChessGUI
extends JFrame
implements BoardMouseListener,
Player {
    Board board;
    BoardGUI bgui;
    boolean iswhitehuman;
    boolean isblackhuman;
    private static final int STATE_SETUP = 0;
    private static final int STATE_WAIT = 1;
    private static final int STATE_PLAY = 2;
    private static final int STATE_END = 3;
    int state;
    Logger logger = LogManager.getLogger("jchess.ChessGUI");

    public ChessGUI(Hashtable params) {
        super("Roman's JChess Version 0.3");
        this.board = new Board();
        this.board.addBoardListener(this);
        this.iswhitehuman = true;
        this.isblackhuman = true;
        String str = (String)params.get("engine");
        if (str == null || str.equals("black")) {
            this.isblackhuman = false;
        } else if (str.equals("white")) {
            this.iswhitehuman = false;
        } else if (str.equals("both")) {
            this.iswhitehuman = false;
            this.isblackhuman = false;
        } else if (!str.equals("none")) {
            throw new IllegalArgumentException();
        }
        this.board.setPlayer(this.iswhitehuman ? this : this.createEngine(params), 0);
        this.board.setPlayer(this.isblackhuman ? this : this.createEngine(params), 128);
        this.board.addBoardListener(this);
        this.bgui = new BoardGUI("/fips/game/jchess/images", this.board);
        this.bgui.setEditable(false);
        this.bgui.addBoardMouseListener(this);
        this.getContentPane().add(this.bgui);
        JMenuBar bar = new JMenuBar();
        JMenu men = new JMenu("Options");
        men.add(new JMenuItem(new AbstractAction("Toggle View"){

            public void actionPerformed(ActionEvent e) {
                ChessGUI.this.bgui.setView(ChessGUI.this.bgui.getView() ^ 0x80);
                ChessGUI.this.logger.fine("Changed view to " + ChessGUI.this.bgui.getView());
            }
        }));
        bar.add(men);
        this.setJMenuBar(bar);
        this.pack();
        this.setVisible(true);
        this.state = -1;
        this.setState(1);
    }

    public void setState(int newstate) {
        this.logger.fine(".setState(newstate=" + newstate + "), old=" + this.state);
        if (newstate == this.state) {
            return;
        }
        switch (newstate) {
            case 1: {
                this.bgui.setPlayMode(true);
                boolean ishuman = this.board.getMover() == 0 ? this.iswhitehuman : this.isblackhuman;
                this.bgui.setEditable(ishuman);
                if (ishuman) break;
                newstate = 2;
            }
            case 2: {
                this.board.start();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal state " + this.state);
            }
        }
        this.state = newstate;
    }

    public void boardChanged(Board board) {
    }

    public void sit(Board b, int color) {
    }

    public void fieldClicked(int pos) {
    }

    public boolean pieceDragged(int from, int to) {
        if (!(this.board.getMover() != 0 ? this.isblackhuman : this.iswhitehuman)) {
            this.logger.severe("Piece dragged from wrong user, should not happen");
            return false;
        }
        switch (this.state) {
            case 1: {
                this.setState(2);
            }
            case 2: {
                try {
                    int[] data = this.board.getData();
                    int np = 0;
                    if ((data[from] & 7) == 1 && (to >> 3 == 0 || to >> 3 == 7)) {
                        this.logger.severe("No piece dialog yet");
                        np = 5;
                    }
                    this.board.makeMove(this, new Move(from, to, np));
                    return true;
                }
                catch (IllegalArgumentException ia) {
                    this.logger.fine("Move was invalid: " + ia);
                    break;
                }
            }
            default: {
                this.logger.severe("No state impl for " + this.state);
            }
        }
        return false;
    }

    private ChessEngine createEngine(Hashtable params) {
        return new ChessEngine();
    }
}

