/*
 * Decompiled with CFR 0.152.
 */
package fips.game.jchess;

import fips.game.jchess.Board;
import fips.game.jchess.ChessDefs;
import fips.game.jchess.Move;
import fips.game.jchess.Player;
import fips.util.LogManager;
import java.util.logging.Logger;

public class ChessEngine
implements Runnable,
Player {
    static final int DEPTH_POS = 64;
    static final int CURRMOVE_POS = 65;
    static final int NEXTMOVE_POS = 66;
    static final int BESTMOVE_POS = 67;
    static final int BESTVAL_POS = 68;
    static final int MOVESUM_POS = 69;
    Board board = null;
    int color = -1;
    int moving = -1;
    Thread thread;
    private boolean haltflag = true;
    boolean easy = true;
    boolean withclock = false;
    int maxdepth = 40;
    int maxmoves = 500000;
    long endtime = -1L;
    int bestmove;
    int bestval;
    Logger logger = LogManager.getLogger("jchess.ChessEngine");
    private static final int[] dirs = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] knightmoves = new int[]{2, 1, -1, -2, -2, -1, 1, 2};
    static final int PAWN_POINTS = 1000;
    static final int BISHOP_POINTS = 3000;
    static final int KNIGHT_POINTS = 3000;
    static final int ROOK_POINTS = 5000;
    static final int QUEEN_POINTS = 9000;
    static final int KING_POINTS = 1000000;
    static final int MATE_POINTS = 500000;
    static final int[] POINT_LIST = new int[]{0, 1000, 3000, 3000, 5000, 9000, 1000000};
    private static final int CHECK_BONUS = 10000;
    private static final int[] KINGFIELDS_PENALTY = new int[]{-300, -100, -50};
    private static final int PROMOTE_BONUS = 200;

    public ChessEngine() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void boardChanged(Board board) {
        this.logger.fine(".boardChanged() entered.");
        this.board = board;
        this.moving = board.getMover();
        this.logger.finer("New mover is " + this.moving);
        this.startEngine();
    }

    public void sit(Board board, int color) {
        if (this.board != null && board != null && this.board != board) {
            throw new IllegalStateException();
        }
        this.board = board;
        this.color = color;
        this.moving = board.getMover();
        if (this.moving == color && board.gameStarted()) {
            System.err.println("ERROR\tfips.game.jchess.ChessEngine#154: no startup yet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEngine() {
        this.logger.fine(".startEngine()");
        Thread thread = this.thread;
        synchronized (thread) {
            this.haltflag = false;
            this.thread.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        int[][] bdlist = new int[this.maxdepth + 1][];
        int i = 0;
        while (i < bdlist.length) {
            bdlist[i] = new int[72];
            ++i;
        }
        int calcmover = 0;
        int resultdepth = 0;
        boolean makemove = false;
        System.err.println("TRACE\tfips.game.jchess.ChessEngine#200: starting calculation thread ...");
        while (true) {
            int[] data;
            Thread thread = this.thread;
            // MONITORENTER : thread
            while (this.haltflag || this.easy && this.color != this.moving) {
                this.logger.finer("Entered halt state ...");
                try {
                    this.thread.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            // MONITOREXIT : thread
            if (calcmover == this.moving) {
                this.logger.severe("No reuse check for cont");
                data = this.board.getData();
                System.arraycopy(data, 0, bdlist[0], 0, data.length);
                resultdepth = 0;
                this.bestmove = -1;
                this.initCalcVars(bdlist, 0);
                bdlist[0][69] = 0;
            } else {
                this.logger.severe("No reuse check for easy mode");
                data = this.board.getData();
                System.arraycopy(data, 0, bdlist[0], 0, data.length);
                resultdepth = 0;
                this.bestmove = -1;
                this.initCalcVars(bdlist, 0);
                bdlist[0][69] = 0;
                calcmover = this.moving;
            }
            if (calcmover != this.color) throw new InternalError("Not implemented");
            while (!this.haltflag && resultdepth < this.maxdepth && !makemove) {
                this.logger.fine("Doing calculations for depth " + resultdepth + ", moves so far " + bdlist[0][69]);
                this.optimizeMove(bdlist, resultdepth + 1, calcmover);
                if (bdlist[0][66] == Integer.MAX_VALUE) {
                    this.bestmove = bdlist[0][67];
                    this.bestval = bdlist[0][68];
                    this.logger.fine("Best move after " + bdlist[0][69] + " moves for depth " + resultdepth + " is 0x" + Integer.toHexString(this.bestmove) + ", value " + this.bestval);
                    this.initCalcVars(bdlist, 0);
                    ++resultdepth;
                } else {
                    this.logger.fine("External stop detected");
                }
                if (resultdepth != this.maxdepth && bdlist[0][69] != this.maxmoves) continue;
                this.logger.fine("Making move: depth is " + resultdepth + ", moves " + bdlist[0][69]);
                makemove = true;
            }
            if (!makemove) continue;
            this.logger.fine("Making move for " + calcmover + ", mine " + this.color);
            if (calcmover == this.color) {
                if (this.bestmove < 0) throw new InternalError("Giving up");
                this.board.makeMove(this, this.createMove(this.bestmove, bdlist[0][this.bestmove >> 8]));
                if (this.easy) {
                    this.haltflag = true;
                }
            }
            makemove = false;
        }
    }

    private void initCalcVars(int[][] bdlist, int depth) {
        bdlist[depth][64] = 0;
        bdlist[depth][65] = -1;
        bdlist[depth][66] = 0;
        bdlist[depth][67] = -1;
        bdlist[depth][68] = 0;
        if (depth != 0) {
            bdlist[depth][69] = bdlist[depth - 1][69];
        }
    }

    /*
     * Exception decompiling
     */
    void optimizeMove(int[][] bdlist, int depthlimit, int currmover) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AnonBreakTarget
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean makeMove(int move, int color, int[] srcb, int[] dstb) {
        srcb[65] = move;
        int pos = move >> 8;
        int piece = srcb[pos];
        if ((piece & 7) == 0 || (piece & 0x80) != color) {
            srcb[66] = pos == 63 ? Integer.MAX_VALUE : pos + 1 << 8;
            return false;
        }
        int moveenum = move & 0xFF;
        System.arraycopy(srcb, 0, dstb, 0, 64);
        int x = pos & 7;
        int y = pos >> 3 & 7;
        int nextmove = -1;
        int endpos = -1;
        int i = -1;
        switch (piece & 7) {
            case 1: {
                boolean toknight = false;
                i = color == 0 ? 8 : -8;
                switch (moveenum) {
                    case 0: 
                    case 4: {
                        if (moveenum == 4 && (i > 0 && x != 6 || i < 0 && x != 1)) {
                            nextmove = 256;
                            break;
                        }
                        nextmove = moveenum + 1;
                        if (srcb[pos + i] == 0) {
                            endpos = pos + i;
                        }
                        if (moveenum != 4) break;
                        toknight = true;
                        break;
                    }
                    case 1: 
                    case 5: {
                        nextmove = moveenum + 1;
                        if (x == 7) break;
                        if (srcb[pos + i + 1] == 0 || (srcb[pos + i + 1] & 0x80) == color) {
                            if (srcb[pos + i + 1] == 0 && (srcb[pos + 1] & 7) == 1 && (srcb[pos + 1] & 0x20) != 0 && (srcb[pos + 1] & 0x80) != color) {
                                endpos = pos + i + 1;
                                dstb[pos + 1] = 0;
                            }
                        } else {
                            endpos = pos + i + 1;
                        }
                        if (moveenum != 5 || (i <= 0 || x != 6) && (i >= 0 || x != 1)) break;
                        toknight = true;
                        break;
                    }
                    case 2: 
                    case 6: {
                        int n = nextmove = moveenum == 6 ? 256 : moveenum + 1;
                        if (x == 0) break;
                        if (srcb[pos + i - 1] == 0 || (srcb[pos + i - 1] & 0x80) == color) {
                            if (srcb[pos + i - 1] == 0 && (srcb[pos - 1] & 7) == 1 && (srcb[pos - 1] & 0x20) != 0 && (srcb[pos - 1] & 0x80) != color) {
                                endpos = pos + i - 1;
                                dstb[pos - 1] = 0;
                            }
                        } else {
                            endpos = pos + i - 1;
                        }
                        if (moveenum != 6 || (i <= 0 || x != 6) && (i >= 0 || x != 1)) break;
                        toknight = true;
                        break;
                    }
                    case 3: {
                        if ((i > 0 && y == 1 || i < 0 && y == 6) && srcb[pos + i] == 0 && srcb[pos + i + i] == 0) {
                            endpos = pos + i + i;
                        }
                        nextmove = moveenum + 1;
                        break;
                    }
                    default: {
                        throw new InternalError("Invalid variant " + moveenum);
                    }
                }
                if (endpos < 0) break;
                if (moveenum == 3) {
                    int n = pos;
                    dstb[n] = dstb[n] | 0x20;
                }
                if ((i = endpos >> 3) != 0 && i != 7) break;
                dstb[pos] = (toknight ? 3 : 5) | 0x10 | color;
                break;
            }
            case 2: {
                int k;
                int diagsel = moveenum >> 2 | 1;
                int dist = moveenum & 7;
                int nx = x + (1 + dist) * dirs[diagsel];
                int ny = y + (1 + dist) * dirs[diagsel + 2 & 7];
                endpos = nx + (ny << 3);
                if (nx < 0 || nx > 7 || ny < 0 || ny > 7 || srcb[endpos] != 0 && (srcb[endpos] & 0x80) == color) {
                    endpos = -1;
                } else {
                    k = pos;
                    int dcnt = 0;
                    while (dcnt < dist) {
                        if (srcb[k += dirs[diagsel] + (dirs[diagsel + 2 & 7] << 3)] != 0) {
                            endpos = -1;
                            break;
                        }
                        ++dcnt;
                    }
                }
                if (endpos < 0) {
                    nextmove = diagsel == 7 ? 256 : diagsel + 2 << 2;
                    break;
                }
                nextmove = moveenum + 1;
                break;
            }
            case 3: {
                if (moveenum > 7) {
                    nextmove = 256;
                    break;
                }
                int nx = x + knightmoves[moveenum];
                int ny = y + knightmoves[moveenum + 2 & 7];
                int n = nextmove = moveenum == 7 ? 256 : moveenum + 1;
                if (nx < 0 || nx >= 8 || ny < 0 || ny >= 8 || (endpos = nx + (ny << 3)) < 0 || srcb[endpos] == 0 || (srcb[endpos] & 0x80) != color) break;
                endpos = -1;
                break;
            }
            case 4: {
                int dcnt;
                int k;
                int ny;
                int nx;
                int direction = moveenum >> 2 & 0xFFFFFFFE;
                int dist = moveenum & 7;
                if (dist < 7 && direction < 7) {
                    nx = x + (1 + dist) * dirs[direction];
                    ny = y + (1 + dist) * dirs[direction + 2 & 7];
                    endpos = nx + (ny << 3);
                    if (nx < 0 || nx > 7 || ny < 0 || ny > 7 || srcb[endpos] != 0 && (srcb[endpos] & 0x80) == color) {
                        endpos = -1;
                    } else {
                        k = pos;
                        dcnt = 0;
                        while (dcnt < dist) {
                            if (srcb[k += dirs[direction] + (dirs[direction + 2 & 7] << 3)] != 0) {
                                endpos = -1;
                                break;
                            }
                            ++dcnt;
                        }
                    }
                }
                if (endpos < 0) {
                    nextmove = direction >= 6 ? 256 : direction + 2 << 2;
                    break;
                }
                nextmove = moveenum + 1;
                break;
            }
            case 5: {
                int dcnt;
                int k;
                int ny;
                int nx;
                int direction = moveenum >> 3;
                int dist = moveenum & 7;
                if (dist < 7 && direction < 8) {
                    nx = x + (1 + dist) * dirs[direction];
                    ny = y + (1 + dist) * dirs[direction + 2 & 7];
                    endpos = nx + (ny << 3);
                    if (nx < 0 || nx > 7 || ny < 0 || ny > 7 || srcb[endpos] != 0 && (srcb[endpos] & 0x80) == color) {
                        endpos = -1;
                    } else {
                        k = pos;
                        dcnt = 0;
                        while (dcnt < dist) {
                            if (srcb[k += dirs[direction] + (dirs[direction + 2 & 7] << 3)] != 0) {
                                endpos = -1;
                                break;
                            }
                            ++dcnt;
                        }
                    }
                }
                if (endpos < 0) {
                    nextmove = direction >= 7 ? 256 : direction + 1 << 3;
                    break;
                }
                nextmove = moveenum + 1;
                break;
            }
            case 6: {
                int ny;
                int nx;
                if (moveenum < 8) {
                    nx = x + dirs[moveenum];
                    ny = y + dirs[moveenum + 2 & 7];
                    endpos = nx + (ny << 3);
                    if (nx < 0 || nx > 7 || ny < 0 || ny > 7 || (srcb[endpos] & 7) != 0 && (srcb[endpos] & 0x80) == color) {
                        endpos = -1;
                    }
                    nextmove = moveenum + 1;
                    break;
                }
                if (moveenum >= 10) break;
                if ((piece & 0x10) != 0 || pos != 4 && pos != 60 || ChessDefs.isAttacked(pos, srcb, color ^ 0x80)) {
                    nextmove = 256;
                    break;
                }
                if (moveenum == 8) {
                    if (!(srcb[pos + 1] != 0 || srcb[pos + 2] != 0 || (srcb[pos + 3] & 7) != 4 || (srcb[pos + 3] & 0x10) != 0 || (srcb[pos + 3] & 0x80) != color || ChessDefs.isAttacked(pos + 1, srcb, color ^ 0x80) || ChessDefs.isAttacked(pos + 2, srcb, color ^ 0x80) || ChessDefs.isAttacked(pos + 3, srcb, color ^ 0x80))) {
                        endpos = pos + 2;
                        dstb[pos + 1] = srcb[pos + 3] | 0x10;
                        dstb[pos + 3] = 0;
                    }
                    nextmove = moveenum + 1;
                    break;
                }
                if (!(srcb[pos - 1] != 0 || srcb[pos - 2] != 0 || srcb[pos - 3] != 0 || (srcb[pos - 4] & 7) != 4 || (srcb[pos - 4] & 0x10) != 0 || (srcb[pos - 4] & 0x80) != color || ChessDefs.isAttacked(pos - 1, srcb, color ^ 0x80) || ChessDefs.isAttacked(pos - 2, srcb, color ^ 0x80) || ChessDefs.isAttacked(pos - 4, srcb, color ^ 0x80))) {
                    endpos = pos - 2;
                    dstb[pos - 1] = srcb[pos - 4] | 0x10;
                    dstb[pos - 4] = 0;
                }
                nextmove = 256;
                break;
            }
            default: {
                throw new InternalError("Piece " + (piece & 7) + " not implemented");
            }
        }
        if (nextmove < 0) {
            throw new InternalError("Nextmove uninitialized for move " + Integer.toHexString(move));
        }
        srcb[66] = pos == 63 ? Integer.MAX_VALUE : (move & 0xFFF00) + nextmove;
        if (endpos < 0) {
            return false;
        }
        dstb[endpos] = dstb[pos] | 0x10;
        dstb[pos] = 0;
        i = 0;
        while (i < 64) {
            if (i != endpos && (dstb[i] & 7) != 0 && (dstb[i] & 0x80) == color) {
                dstb[i] = dstb[i] & 0xFFFFFFDF;
            }
            ++i;
        }
        return true;
    }

    int evaluateBoard(int[] data) {
        int y;
        int x;
        int score = 0;
        int[] attacklist = new int[64];
        int attackscore = 0;
        int pos = 0;
        while (pos < 64) {
            if (data[pos] != 0) {
                int piece = data[pos] & 7;
                int color = data[pos] & 0x80;
                int mask = color == 0 ? 1 : 256;
                int attackpart = 0;
                switch (piece) {
                    case 1: {
                        int otherpiece;
                        int x2;
                        if (color == 0) {
                            x2 = pos & 7;
                            if (x2 != 0) {
                                int n = pos + 7;
                                attacklist[n] = attacklist[n] + mask;
                                otherpiece = data[pos + 7] & 7;
                                if (otherpiece != 0 && (data[pos + 7] & 0x80) != color) {
                                    attackpart = otherpiece == 6 ? 10000 : POINT_LIST[otherpiece];
                                    score += 200;
                                }
                            }
                            if (x2 != 7) {
                                int n = pos + 9;
                                attacklist[n] = attacklist[n] + mask;
                                otherpiece = data[pos + 9] & 7;
                                if (otherpiece != 0 && (data[pos + 9] & 0x80) != color) {
                                    attackpart = otherpiece == 6 ? 10000 : POINT_LIST[otherpiece];
                                    score += 200;
                                }
                            }
                            if (pos >> 3 != 6 || data[pos + 8] != 0) break;
                            score += 200;
                            break;
                        }
                        x2 = pos & 7;
                        if (x2 != 0) {
                            int n = pos - 9;
                            attacklist[n] = attacklist[n] + mask;
                            otherpiece = data[pos - 9] & 7;
                            if (otherpiece != 0 && (data[pos - 9] & 0x80) != color) {
                                attackpart = otherpiece == 6 ? 10000 : POINT_LIST[otherpiece];
                                score -= 200;
                            }
                        }
                        if (x2 != 7) {
                            int n = pos - 7;
                            attacklist[n] = attacklist[n] + mask;
                            otherpiece = data[pos - 7] & 7;
                            if (otherpiece != 0 && (data[pos - 7] & 0x80) != color) {
                                attackpart = otherpiece == 6 ? 10000 : POINT_LIST[otherpiece];
                                score -= 200;
                            }
                        }
                        if (pos >> 3 != 1 || data[pos - 8] != 0) break;
                        score -= 200;
                        break;
                    }
                    case 2: {
                        int otherpiece;
                        int dircnt = 1;
                        while (dircnt < 8) {
                            x = (pos & 7) + dirs[dircnt];
                            y = (pos >> 3) + dirs[dircnt + 2 & 7];
                            while (x >= 0 && x < 8 && y >= 0 && y < 8) {
                                int apos;
                                int n = apos = x + (y << 3);
                                attacklist[n] = attacklist[n] + mask;
                                otherpiece = data[apos] & 7;
                                if (otherpiece != 0) {
                                    if ((data[apos] & 0x80) == color) break;
                                    attackpart = otherpiece == 6 ? 10000 : POINT_LIST[otherpiece];
                                    break;
                                }
                                x += dirs[dircnt];
                                y += dirs[dircnt + 2 & 7];
                            }
                            dircnt += 2;
                        }
                        break;
                    }
                    case 3: {
                        int otherpiece;
                        int i = 0;
                        while (i < 8) {
                            int x3 = (pos & 7) + knightmoves[i];
                            int y2 = (pos >> 3) + knightmoves[i + 2 & 7];
                            if (x3 >= 0 && x3 < 8 && y2 >= 0 && y2 < 8) {
                                int apos;
                                int n = apos = x3 + (y2 << 3);
                                attacklist[n] = attacklist[n] + mask;
                                otherpiece = data[apos] & 7;
                                if (otherpiece != 0 && (data[apos] & 0x80) != color) {
                                    attackpart = otherpiece == 6 ? 10000 : POINT_LIST[otherpiece];
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    case 4: {
                        int otherpiece;
                        int dircnt = 0;
                        while (dircnt < 8) {
                            int x4 = (pos & 7) + dirs[dircnt];
                            int y3 = (pos >> 3) + dirs[dircnt + 2 & 7];
                            while (x4 >= 0 && x4 < 8 && y3 >= 0 && y3 < 8) {
                                int apos;
                                int n = apos = x4 + (y3 << 3);
                                attacklist[n] = attacklist[n] + mask;
                                otherpiece = data[apos] & 7;
                                if (otherpiece != 0) {
                                    if ((data[apos] & 0x80) == color) break;
                                    attackpart = otherpiece == 6 ? 10000 : POINT_LIST[otherpiece];
                                    break;
                                }
                                x4 += dirs[dircnt];
                                y3 += dirs[dircnt + 2 & 7];
                            }
                            dircnt += 2;
                        }
                        break;
                    }
                    case 5: {
                        int otherpiece;
                        int dircnt = 0;
                        while (dircnt < 8) {
                            int x5 = (pos & 7) + dirs[dircnt];
                            int y4 = (pos >> 3) + dirs[dircnt + 2 & 7];
                            while (x5 >= 0 && x5 < 8 && y4 >= 0 && y4 < 8) {
                                int apos;
                                int n = apos = x5 + (y4 << 3);
                                attacklist[n] = attacklist[n] + mask;
                                otherpiece = data[apos] & 7;
                                if (otherpiece != 0) {
                                    if ((data[apos] & 0x80) == color) break;
                                    attackpart = otherpiece == 6 ? 10000 : POINT_LIST[otherpiece];
                                    break;
                                }
                                x5 += dirs[dircnt];
                                y4 += dirs[dircnt + 2 & 7];
                            }
                            ++dircnt;
                        }
                        break;
                    }
                    case 6: {
                        int otherpiece;
                        int dircnt = 1;
                        while (dircnt < 8) {
                            int x6 = (pos & 7) + dirs[dircnt];
                            int y5 = (pos >> 3) + dirs[dircnt + 2 & 7];
                            if (x6 >= 0 && x6 < 8 && y5 >= 0 && y5 < 8) {
                                int apos;
                                int n = apos = x6 + (y5 << 3);
                                attacklist[n] = attacklist[n] + mask;
                                otherpiece = data[apos] & 7;
                                if (otherpiece != 0 && (data[apos] & 0x80) != color) {
                                    attackpart = POINT_LIST[otherpiece];
                                }
                            }
                            dircnt += 2;
                        }
                        break;
                    }
                    default: {
                        throw new InternalError("Field " + data[pos]);
                    }
                }
                if (attackpart < 0) {
                    attackpart = 0;
                } else {
                    attackscore = color == 0 ? (attackscore += attackpart) : (attackscore -= attackpart);
                }
            }
            ++pos;
        }
        score += attackscore / 50;
        int whiteattacks = 0;
        int blackattacks = 0;
        int pos2 = 0;
        while (pos2 < 64) {
            whiteattacks += attacklist[pos2] & 0xFF;
            blackattacks += attacklist[pos2] >> 8 & 0xFF;
            if ((data[pos2] & 7) == 6) {
                int availfields = 0;
                int mask = (data[pos2] & 0x80) == 0 ? 65280 : 255;
                int i = 0;
                while (i < 8) {
                    x = (pos2 & 7) + dirs[i];
                    y = (pos2 >> 3) + dirs[i + 2 & 7];
                    if (x >= 0 && x < 8 && y >= 0 && y < 8 && (attacklist[x + (y << 3)] & mask) == 0) {
                        ++availfields;
                    }
                    ++i;
                }
                if (availfields < KINGFIELDS_PENALTY.length) {
                    score = (data[pos2] & 0x80) == 0 ? (score += KINGFIELDS_PENALTY[availfields]) : (score -= KINGFIELDS_PENALTY[availfields]);
                }
            }
            ++pos2;
        }
        score += whiteattacks;
        score -= blackattacks;
        int pos3 = 0;
        while (pos3 < 64) {
            int piece = data[pos3] & 7;
            if (piece != 0) {
                int delta = POINT_LIST[piece];
                int color = data[pos3] & 0x80;
                score = color == 128 ? (score -= delta) : (score += delta);
            }
            ++pos3;
        }
        return score;
    }

    private Move createMove(int val, int piece) {
        int from = val >> 8;
        int to = -1;
        int newpiece = 0;
        int variant = val & 0xFF;
        int color = piece & 0x80;
        int fx = from & 7;
        int fy = from >> 3;
        switch (piece & 7) {
            case 1: {
                boolean toknight = false;
                int direction = color == 0 ? 8 : -8;
                switch (variant) {
                    case 4: {
                        toknight = true;
                    }
                    case 0: {
                        to = from + direction;
                        break;
                    }
                    case 5: {
                        toknight = true;
                    }
                    case 1: {
                        to = from + direction + 1;
                        break;
                    }
                    case 6: {
                        toknight = true;
                    }
                    case 2: {
                        to = from + direction - 1;
                        break;
                    }
                    case 3: {
                        to = from + direction + direction;
                    }
                }
                if (to >> 3 != 0 && to >> 3 != 7) break;
                newpiece = toknight ? 3 : 5;
                break;
            }
            case 2: {
                int direction = variant >> 2 | 1;
                int dist = variant & 7;
                to = from + (1 + dist) * dirs[direction] + ((1 + dist) * dirs[direction + 2 & 7] << 3);
                break;
            }
            case 3: {
                to = from + knightmoves[variant] + (knightmoves[variant + 2 & 7] << 3);
                break;
            }
            case 4: {
                int direction = variant >> 2 & 0xFFFFFFFE;
                int dist = variant & 7;
                to = from + (1 + dist) * dirs[direction] + ((1 + dist) * dirs[direction + 2 & 7] << 3);
                break;
            }
            case 5: {
                int direction = variant >> 3;
                int dist = variant & 7;
                to = from + (1 + dist) * dirs[direction] + ((1 + dist) * dirs[direction + 2 & 7] << 3);
                break;
            }
            case 6: {
                if (variant < 8) {
                    to = from + dirs[variant] + (dirs[variant + 2 & 7] << 3);
                    break;
                }
                if (variant == 8) {
                    to = from + 2;
                    break;
                }
                if (variant != 9) break;
                to = from - 2;
                break;
            }
            default: {
                throw new InternalError("Illegal piece " + piece);
            }
        }
        return new Move(from, to, newpiece);
    }
}

