/*
 * Decompiled with CFR 0.152.
 */
package fips.game.jchess;

public class ChessDefs {
    public static final int EMPTY = 0;
    public static final int PAWN = 1;
    public static final int BISHOP = 2;
    public static final int KNIGHT = 3;
    public static final int ROOK = 4;
    public static final int QUEEN = 5;
    public static final int KING = 6;
    public static final int PIECE = 7;
    public static final int MOVED = 16;
    public static final int MOVED2 = 32;
    public static final int WHITE = 0;
    public static final int BLACK = 128;
    public static final int COLOR = 128;

    public static boolean isAttacked(int pos, int[] board, int color) {
        if (board[pos] != 0 && (board[pos] & 0x80) == color) {
            return false;
        }
        int tpos = 0;
        while (tpos < 64) {
            if (tpos != pos && board[tpos] != 0 && (board[tpos] & 0x80) == color) {
                switch (board[tpos] & 7) {
                    case 1: {
                        int i = (tpos & 7) - (pos & 7);
                        int j = (tpos >> 3) - (pos >> 3);
                        if (i != -1 && i != 1 || j != -1 && j != 1 || !(color == 0 ? j == -1 : j == 1)) break;
                        return true;
                    }
                    case 2: {
                        int i = (tpos & 7) - (pos & 7);
                        int j = (tpos >> 3) - (pos >> 3);
                        if (i != j && i != -j) break;
                        int k = pos;
                        do {
                            k += i > 0 ? 1 : -1;
                            if ((k += j > 0 ? 8 : -8) != tpos) continue;
                            return true;
                        } while (board[k] == 0);
                        break;
                    }
                    case 3: {
                        int i = (tpos & 7) - (pos & 7);
                        int j = (tpos >> 3) - (pos >> 3);
                        if (i < 0) {
                            i = -i;
                        }
                        if (j < 0) {
                            j = -j;
                        }
                        if (i + j != 3 || i * j != 2) break;
                        return true;
                    }
                    case 4: {
                        int i;
                        if ((pos & 7) != (tpos & 7) && (pos & 0x38) != (tpos & 0x38)) break;
                        if ((pos & 0x38) == (tpos & 0x38)) {
                            i = pos;
                            do {
                                if ((i += pos < tpos ? 1 : -1) != tpos) continue;
                                return true;
                            } while (board[i] == 0);
                            break;
                        }
                        i = pos;
                        do {
                            if ((i += pos < tpos ? 8 : -8) != tpos) continue;
                            return true;
                        } while (board[i] == 0);
                        break;
                    }
                    case 5: {
                        int k;
                        int i = (tpos & 7) - (pos & 7);
                        int j = (tpos >> 3) - (pos >> 3);
                        if (i == j || i == -j) {
                            k = pos;
                            do {
                                k += i > 0 ? 1 : -1;
                                if ((k += j > 0 ? 8 : -8) != tpos) continue;
                                return true;
                            } while (board[k] == 0);
                            break;
                        }
                        if (i != 0 && j != 0) break;
                        int n = i < 0 ? -1 : (i = i > 0 ? 1 : 0);
                        j = j < 0 ? -8 : (j > 0 ? 8 : 0);
                        k = pos;
                        do {
                            if ((k += i + j) != tpos) continue;
                            return true;
                        } while (board[k] == 0);
                        break;
                    }
                    case 6: {
                        int i = (tpos & 7) - (pos & 7);
                        int j = (tpos >> 3) - (pos >> 3);
                        if (i < -1 || i > 1 || j < -1 || j > 1) break;
                        return true;
                    }
                    default: {
                        throw new InternalError("Piece " + (board[tpos] & 7) + " not implemented");
                    }
                }
            }
            ++tpos;
        }
        return false;
    }
}

