/*
 * Decompiled with CFR 0.152.
 */
package fips.game.jchess;

import fips.game.jchess.Board;
import fips.game.jchess.BoardListener;
import fips.game.jchess.BoardMouseListener;
import fips.util.LogManager;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class BoardGUI
extends JComponent
implements MouseMotionListener,
MouseListener,
BoardListener {
    public static final String[] piecenames = new String[]{"fieldw.gif", "pawnw.gif", "bishopw.gif", "knightw.gif", "rookw.gif", "queenw.gif", "kingw.gif", "fieldb.gif", "pawnb.gif", "bishopb.gif", "knightb.gif", "rookb.gif", "queenb.gif", "kingb.gif"};
    Board board;
    int[] olddata;
    int view;
    Image[] pieces;
    int cellsize;
    Image buffer;
    boolean editable;
    boolean playmode;
    ArrayList listeners;
    Point click_point;
    Point click_offset;
    Image drag_image;
    Point drag_point;
    boolean extern_drag;
    Logger logger = LogManager.getLogger("jchess.BoardGUI");

    public BoardGUI(String series, Board board) {
        this.board = board;
        board.addBoardListener(this);
        this.view = 0;
        this.pieces = new Image[14];
        int i = 0;
        while (i < this.pieces.length) {
            try {
                InputStream in = this.getClass().getResourceAsStream(series + "/" + piecenames[i]);
                byte[] buf = new byte[in.available()];
                int m = 0;
                while (m < buf.length) {
                    int n = in.read(buf, m, buf.length - m);
                    if (n <= 0) continue;
                    m += n;
                }
                this.pieces[i] = Toolkit.getDefaultToolkit().createImage(buf);
                this.prepareImage(this.pieces[i], this);
                while (this.pieces[i].getWidth(this) <= 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                System.err.println("ERROR\tfips.game.jchess.BoardGUI#119: can't load image for piece " + piecenames[i]);
                e.printStackTrace();
            }
            ++i;
        }
        this.cellsize = this.pieces[0].getWidth(null);
        int i2 = 0;
        while (i2 < this.pieces.length) {
            if (this.cellsize != this.pieces[i2].getWidth(null) || this.cellsize != this.pieces[i2].getHeight(null)) {
                System.err.println("ERROR\tfips.game.jchess.BoardGUI#128: picture " + piecenames[i2] + " has invalid size.");
                throw new IllegalArgumentException("Picture " + piecenames[i2] + " has invalid size.");
            }
            ++i2;
        }
        this.setSize(this.cellsize << 3, this.cellsize << 3);
        this.setPreferredSize(new Dimension(this.cellsize << 3, this.cellsize << 3));
        this.editable = false;
        this.playmode = false;
        this.listeners = new ArrayList();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public int getView() {
        return this.view;
    }

    public void setView(int color) {
        this.logger.fine(".setView(color=" + color + "), old=" + this.view);
        if (color != 0 && color != 128) {
            throw new IllegalArgumentException();
        }
        if (color != this.view) {
            this.view = color;
            this.olddata = null;
            this.buffer = null;
            this.repaint();
        }
    }

    public void setEditable(boolean val) {
        this.editable = val;
    }

    public void setPlayMode(boolean val) {
        this.playmode = val;
    }

    public void boardChanged(Board board) {
        this.logger.fine("boardChanged()");
        this.board = board;
        this.paintBuffer(board.getData());
        this.repaint();
    }

    private void drawPiece(Graphics g, int piece, int pos) {
        int x = pos & 7;
        int y = pos >> 3;
        if (this.view == 0) {
            y = 7 - y;
        } else {
            x = 7 - x;
        }
        g.drawImage(this.pieces[((x ^ y) & 1) == 0 ? 0 : 7], x * this.cellsize, y * this.cellsize, null);
        if ((piece & 7) == 0) {
            return;
        }
        if (((piece &= 0x87) & 0x80) != 0) {
            piece = (piece & 7) + 7;
        }
        this.logger.finer("drawing " + piece + " at " + x + "x" + y);
        g.drawImage(this.pieces[piece], x * this.cellsize, y * this.cellsize, null);
    }

    private void paintBuffer(int[] data) {
        this.logger.fine("paintBuffer()");
        if (this.buffer == null) {
            this.buffer = this.createImage(this.cellsize << 3, this.cellsize << 3);
            this.olddata = null;
        }
        Graphics g = null;
        if (this.olddata == null || !Arrays.equals(this.olddata, data)) {
            int x = 0;
            while (x < 8) {
                int y = 0;
                while (y < 8) {
                    if (data == null || this.olddata == null || this.olddata[x + (y << 3)] != data[x + (y << 3)]) {
                        if (g == null) {
                            g = this.buffer.getGraphics();
                        }
                        this.drawPiece(g, data == null ? 0 : data[x + (y << 3)], x + (y << 3));
                    }
                    ++y;
                }
                ++x;
            }
        }
        this.olddata = data;
    }

    public void paintComponent(Graphics g) {
        this.logger.fine(".paintComponent()");
        if (this.cellsize <= 0) {
            return;
        }
        if (this.buffer == null) {
            this.paintBuffer(this.board.getData());
        }
        g.drawImage(this.buffer, 0, 0, null);
        if (this.drag_image != null && this.drag_point != null) {
            g.drawImage(this.drag_image, this.drag_point.x - this.click_offset.x, this.drag_point.y - this.click_offset.y, null);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.logger.severe("Not yet ...");
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.logger.fine("mousePressed() at " + e.getX() + "x" + e.getY());
        this.drag_image = null;
        if (!this.editable) {
            return;
        }
        this.click_point = e.getPoint();
        int pos = this.pointToPos(this.click_point);
        int[] data = this.board.getData();
        if (pos < 0 || data == null || data[pos] == 0 || this.playmode && (data[pos] & 0x80) != this.board.getMover()) {
            this.logger.finer("Not valid click position pos=" + pos);
            this.click_point = null;
            return;
        }
        this.click_offset = new Point(this.click_point.x % this.cellsize, this.click_point.y % this.cellsize);
    }

    public void mouseReleased(MouseEvent e) {
        this.logger.fine("mouseReleased() ");
        int startpos = this.click_point == null ? -1 : this.pointToPos(this.click_point);
        int endpos = this.pointToPos(e.getPoint());
        if (!this.editable) {
            this.logger.finer("No action if not in editmode");
        } else if (this.extern_drag) {
            this.logger.severe("Drag from outside not yet impl.");
        } else if (this.click_point != null) {
            if (this.click_point.equals(e.getPoint())) {
                this.logger.finer("Click detected, ignoring it");
            } else if (startpos == endpos) {
                if (!this.playmode) {
                    this.logger.severe("Not yet: like clicked");
                }
            } else {
                boolean nopaint = true;
                int[] data = this.board.getData();
                nopaint = this.playmode ? (data[endpos] == 0 || (data[endpos] & 0x80) != (data[startpos] & 0x80) ? this.firePieceDragged(startpos, endpos) : false) : this.firePieceDragged(startpos, endpos);
                if (nopaint) {
                    this.logger.fine("Drag valid, updating buffer");
                    this.paintBuffer(this.board.getData());
                } else {
                    this.logger.fine("Drag invalid, reverting buffer");
                    if (this.olddata != null) {
                        this.olddata[startpos] = -1;
                        this.olddata[endpos] = -1;
                    }
                    this.paintBuffer(data);
                }
                this.repaint();
            }
        }
        this.click_point = null;
        this.drag_image = null;
        this.extern_drag = false;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.logger.fine("mouseDragged()");
        if (!this.extern_drag && this.click_point == null) {
            return;
        }
        if (this.drag_image == null) {
            int piece;
            int pos = this.pointToPos(this.click_point);
            this.drag_image = this.pieces[(piece & 7) + (((piece = this.board.getData()[pos]) & 0x80) != 0 ? 7 : 0)];
            this.drawPiece(this.buffer.getGraphics(), 0, pos);
        }
        this.drag_point = e.getPoint();
        this.repaint();
    }

    private int pointToPos(Point p) {
        int x = p.x / this.cellsize;
        int y = p.y / this.cellsize;
        if (this.view == 0) {
            y = 7 - y;
        } else {
            x = 7 - x;
        }
        if (x < 0 || x > 7 || y < 0 || y > 7) {
            return -1;
        }
        return x + (y << 3);
    }

    public void addBoardMouseListener(BoardMouseListener bml) {
        if (bml != null) {
            this.listeners.add(bml);
        }
    }

    public void removeBoardMouseListener(BoardMouseListener bml) {
        this.listeners.remove(bml);
    }

    public boolean firePieceDragged(int from, int to) {
        boolean nopaint = true;
        int i = 0;
        while (i < this.listeners.size()) {
            nopaint &= ((BoardMouseListener)this.listeners.get(i)).pieceDragged(from, to);
            ++i;
        }
        return nopaint;
    }
}

