/*
 * Decompiled with CFR 0.152.
 */
package fips.game.jchess;

import fips.game.jchess.BoardListener;
import fips.game.jchess.ChessDefs;
import fips.game.jchess.Move;
import fips.game.jchess.Player;
import fips.util.LogManager;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Board {
    ArrayList history;
    int[] data;
    int moving;
    ArrayList boardlisteners;
    Player white;
    Player black;
    boolean started;
    Logger logger = LogManager.getLogger("jchess.Board");

    public Board() {
        this.history = new ArrayList();
        this.boardlisteners = new ArrayList();
        this.data = new int[64];
        this.reset();
    }

    public int[] getData() {
        return (int[])this.data.clone();
    }

    public int getMover() {
        this.logger.fine(".getMover(): " + this.moving);
        return this.moving;
    }

    public void reset() {
        if (this.started) {
            throw new IllegalStateException("Stop game first");
        }
        this.moving = 0;
        this.history.clear();
        this.data = new int[64];
        int i = 0;
        while (i < 8) {
            this.data[8 + i] = 1;
            this.data[48 + i] = 129;
            ++i;
        }
        int i2 = 0;
        while (i2 < 8) {
            this.data[i2] = 0;
            this.data[56 + i2] = 128;
            ++i2;
        }
        this.data[0] = this.data[0] | 4;
        this.data[7] = this.data[7] | 4;
        this.data[1] = this.data[1] | 3;
        this.data[6] = this.data[6] | 3;
        this.data[2] = this.data[2] | 2;
        this.data[5] = this.data[5] | 2;
        this.data[3] = this.data[3] | 5;
        this.data[4] = this.data[4] | 6;
        this.data[56] = this.data[56] | 4;
        this.data[63] = this.data[63] | 4;
        this.data[57] = this.data[57] | 3;
        this.data[62] = this.data[62] | 3;
        this.data[58] = this.data[58] | 2;
        this.data[61] = this.data[61] | 2;
        this.data[59] = this.data[59] | 5;
        this.data[60] = this.data[60] | 6;
        this.notifyBoardListeners();
    }

    public void setPiece(int position, int piece, int color) {
        if (this.started) {
            throw new IllegalArgumentException();
        }
        throw new InternalError();
    }

    public boolean gameStarted() {
        return this.started;
    }

    public void start() {
        if (this.started) {
            throw new IllegalArgumentException();
        }
        if (this.history.size() == 0) {
            this.history.add(this.data);
        }
        this.logger.severe("No timer support yet");
        this.started = true;
    }

    public void stop() {
    }

    public void setPlayer(Player player, int color) throws IllegalStateException {
        if (color == 0) {
            if (player == this.white) {
                return;
            }
            if (this.white != null) {
                player.sit(null, color);
                this.removeBoardListener(player);
            }
            this.white = player;
        } else if (color == 128) {
            if (player == this.black) {
                return;
            }
            if (this.black != null) {
                player.sit(null, color);
                this.removeBoardListener(player);
            }
            this.black = player;
            player.sit(this, color);
            player.boardChanged(this);
        } else {
            throw new IllegalArgumentException();
        }
        player.sit(this, color);
        player.boardChanged(this);
        this.addBoardListener(player);
    }

    public void makeMove(Player player, Move move) throws IllegalArgumentException {
        if (!this.started) {
            throw new IllegalStateException();
        }
        int[] newdata = null;
        try {
            newdata = this.checkMove(player, move);
        }
        catch (IllegalArgumentException e) {
            this.logger.fine("Move " + move.from + " to " + move.to + " not accepted: " + e);
            this.logger.log(Level.FINER, "Cause ", e);
            throw e;
        }
        this.history.add(this.data);
        this.data = newdata;
        this.moving ^= 0x80;
        this.notifyBoardListeners();
    }

    private int[] checkMove(Player p, Move move) throws IllegalArgumentException {
        if (p != (this.moving == 0 ? this.white : this.black)) {
            throw new IllegalArgumentException("Wrong player");
        }
        int piece = this.data[move.from];
        int color = piece & 0x80;
        if ((piece & 7) == 0 || color != this.moving) {
            throw new IllegalArgumentException("No piece at " + move.from);
        }
        if ((this.data[move.to] & 7) != 0 && (this.data[move.to] & 0x80) == this.moving) {
            throw new IllegalArgumentException("Can't attack own piece");
        }
        int[] newdata = new int[64];
        System.arraycopy(this.data, 0, newdata, 0, 64);
        int i = 0;
        while (i < 64) {
            if (newdata[i] != 0 && (newdata[i] & 0x80) == this.moving) {
                int n = i;
                newdata[n] = newdata[n] & 0xFFFFFFDF;
            }
            ++i;
        }
        int fx = move.from & 7;
        int fy = move.from >> 3;
        int tx = move.to & 7;
        int ty = move.to >> 3;
        int dx = tx - fx;
        int dy = ty - fy;
        switch (piece & 7) {
            case 1: {
                if (dx != 1 && dx != 0 && dx != -1) {
                    throw new IllegalArgumentException("Pawn may only move 1 forward, left and right");
                }
                if (dx == 0 && (this.data[move.to] & 7) != 0) {
                    throw new IllegalArgumentException("Pawn can't attack directly");
                }
                if (color == 0 && dy != 1 && dy != 2 || color == 128 && dy != -1 && dy != -2) {
                    throw new IllegalArgumentException();
                }
                if (dx != 0) {
                    if (dy != 1 && dy != -1) {
                        throw new IllegalArgumentException();
                    }
                    if ((this.data[move.to] & 7) != 0) {
                        if ((this.data[move.to] & 0x80) == color) {
                            throw new IllegalArgumentException();
                        }
                    } else if ((this.data[move.from + dx] & 0x20) != 0 && (this.data[move.from + dx] & 0x80) != color) {
                        newdata[move.from + dx] = 0;
                        this.logger.finest("En passant accepted");
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
                if (color == 0) {
                    if (dy == 2) {
                        if (fy != 1 || dx != 0 || (this.data[move.from + 8] & 7) != 0) {
                            throw new IllegalArgumentException();
                        }
                        int n = move.from;
                        newdata[n] = newdata[n] | 0x20;
                    }
                } else if (dy == -2) {
                    if (fy != 6 || dx != 0 || (this.data[move.from - 8] & 7) != 0) {
                        throw new IllegalArgumentException();
                    }
                    int n = move.from;
                    newdata[n] = newdata[n] | 0x20;
                }
                if (ty != 0 && ty != 7) break;
                int n = move.from;
                newdata[n] = newdata[n] & 0xFFFFFFF8;
                int n2 = move.from;
                newdata[n2] = newdata[n2] | move.newpiece & 7;
                if ((newdata[move.from] & 7) != 0) break;
                this.logger.finest("Default promote to queen");
                int n3 = move.from;
                newdata[n3] = newdata[n3] | 5;
                break;
            }
            case 2: {
                if (dx != dy && dx != -dy) {
                    throw new IllegalArgumentException();
                }
                int dir = (dx < 0 ? -1 : 1) + (dy < 0 ? -8 : 8);
                int i2 = move.from + dir;
                while (i2 != move.to) {
                    if (this.data[i2] != 0) {
                        throw new IllegalArgumentException();
                    }
                    i2 += dir;
                }
                break;
            }
            case 3: {
                if (dx < 0) {
                    dx = -dx;
                }
                if (dy < 0) {
                    dy = -dy;
                }
                if (!(dx != 1 && dy != 1 || dx != 2 && dy != 2) && (dx == dy + 1 || dy == dx + 1)) break;
                throw new IllegalArgumentException();
            }
            case 4: {
                if (dx != 0 && dy != 0) {
                    throw new IllegalArgumentException();
                }
                if (dx != 0) {
                    int n = dx = dx < 0 ? -1 : 1;
                }
                if (dy != 0) {
                    dy = dy < 0 ? -8 : 8;
                }
                int i3 = move.from + dx + dy;
                while (i3 != move.to) {
                    if (this.data[i3] != 0) {
                        throw new IllegalArgumentException();
                    }
                    i3 += dx + dy;
                }
                break;
            }
            case 5: {
                if (dx != 0 && dy != 0 && dy != dx && dy != -dx) {
                    throw new IllegalArgumentException();
                }
                if (dx != 0) {
                    int n = dx = dx < 0 ? -1 : 1;
                }
                if (dy != 0) {
                    dy = dy < 0 ? -8 : 8;
                }
                int i4 = move.from + dx + dy;
                while (i4 != move.to) {
                    if (this.data[i4] != 0) {
                        throw new IllegalArgumentException();
                    }
                    i4 += dx + dy;
                }
                break;
            }
            case 6: {
                if (dx == 2 || dx == -2) {
                    int i5;
                    int rookp = (dx < 0 ? 0 : 7) + (fy << 3);
                    if ((this.data[move.to] & 0x10) != 0 || fx != 4 || dy != 0 || fy != 0 && fy != 7 || (this.data[rookp] & 7) != 4 || (this.data[rookp] & 0x80) != color) {
                        throw new IllegalArgumentException();
                    }
                    if (dx < 0) {
                        i5 = 0;
                        while (i5 < 5) {
                            if (i5 != 0 && i5 != 4 && this.data[move.from - i5] != 0) {
                                throw new IllegalArgumentException();
                            }
                            if (ChessDefs.isAttacked(move.from - i5, this.data, color ^ 0x80)) {
                                throw new IllegalArgumentException();
                            }
                            ++i5;
                        }
                        newdata[move.from - 1] = newdata[rookp] | 0x10;
                        newdata[rookp] = 0;
                        break;
                    }
                    i5 = 0;
                    while (i5 < 4) {
                        if (i5 != 0 && i5 != 3 && this.data[move.from + i5] != 0) {
                            throw new IllegalArgumentException();
                        }
                        if (ChessDefs.isAttacked(move.from + i5, this.data, color ^ 0x80)) {
                            throw new IllegalArgumentException();
                        }
                        ++i5;
                    }
                    newdata[move.from + 1] = newdata[rookp] | 0x10;
                    newdata[rookp] = 0;
                    break;
                }
                if (dx >= -1 && dx <= 1 && dy >= -1 && dy <= 1) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException("Illegal piece " + piece);
            }
        }
        newdata[move.to] = newdata[move.from] | 0x10;
        newdata[move.from] = 0;
        if (color == 0 && ty == 5 && (newdata[move.to - 8] & 0x20) != 0) {
            newdata[move.to - 8] = 0;
        }
        if (color == 128 && ty == 2 && (newdata[move.to + 8] & 0x20) != 0) {
            newdata[move.to + 8] = 0;
        }
        this.logger.fine("Made move, doing mate check");
        int i6 = 0;
        while (i6 < 64) {
            if ((newdata[i6] & 0x80) == this.moving && (newdata[i6] & 7) == 6) {
                if (!ChessDefs.isAttacked(i6, newdata, this.moving ^ 0x80)) break;
                throw new IllegalArgumentException("Protect your king");
            }
            ++i6;
        }
        return newdata;
    }

    public void addBoardListener(BoardListener bl) {
        if (bl != null) {
            this.boardlisteners.add(bl);
        }
    }

    public void removeBoardListener(BoardListener bl) {
        this.boardlisteners.remove(bl);
    }

    private void notifyBoardListeners() {
        int i = 0;
        while (i < this.boardlisteners.size()) {
            ((BoardListener)this.boardlisteners.get(i)).boardChanged(this);
            ++i;
        }
    }
}

