/*Copyright Roman Fiedler: fiedler0@sbox.tu-graz.ac.at*/

#include <dos.h>
#include <conio.h>
#include <stdio.h>
/*Address of the parallel port: 0x278 0x378 0x2F8 0x3F8 are commonly used*/
#define ADDRESS 0x278
/*lower value makes programm faster  20*/
#define FAKT 20

/*Each row contains 2 values:
1st value: Describes, which lights should be switched on.
LED     Value    LED
Red1   :1  0x01  Red2   :8  0x08
Orange1:2  0x02  Orange2:16 0x10
Green1 :4  0x04  Green2 :32 0x20
If you want to switch on several LEDs, add up the values corresponding to
the LEDs.
Red1,Green1,Orange2 on: 1+4+16=21=0x15

2nd value: Timespan to display this value
*/

unsigned int lights[]={
0x09,20,         /*0  r   r  */
0x0B,30,         /*1  ro  r  */
0x0C,200,        /*2    g r  */
0x08,10,         /*3      r  */
0x0C,10,         /*4    g r  */
0x08,10,         /*5      r  */
0x0C,10,         /*6    g r  */
0x08,10,         /*7      r  */
0x0C,10,         /*8    g r  */
0x08,10,         /*9      r  */
0x0C,10,         /*10   g r  */
0x0A,50,         /*11  o  r  */
0x09,20,	 /*12 r   r  */
0x19,30,         /*13 r   ro */
0x21,200,        /*14 r     g*/
0x01,10,         /*15 r      */
0x21,10,         /*16 r     g*/
0x01,10,         /*17 r      */
0x21,10,         /*18 r     g*/
0x01,10,         /*19 r      */
0x21,10,         /*20 r     g*/
0x01,10,         /*21 r      */
0x21,10,         /*22 r     g*/
0x11,50,         /*23 r    o */
};

int elements=24; /*number of light-combinations*/

void DrawLights(char data)
 {
  char i=1,col,a;

  while(i<8)
   {
    switch(i)
     {case 1: col=4; a=5; break;
      case 2: col=14; a=10; break;
      case 4: col=2; a=15; break;
     }
    if(!(data&i)) col=0;
    textcolor(col);
    col=0;
    while(col<4)
     {
      gotoxy(34,a+col);
      cprintf("");
      col++;
     }
    i=i*2;
   }
  textcolor(7);
  textbackground(0);
  gotoxy(1,1);
 }

void main()
 {
  char c;
  int i;

  textcolor(7);
  textbackground(0);
  clrscr();
  gotoxy(31,3);
  cprintf("**************");
  gotoxy(31,20);
  cprintf("**************");
  c=4;
  while(c<20)
   {
    gotoxy(31,c);
    cprintf("*            *");
    c++;
   }
  i=0;
  c=0;
  while(c!=27)
   {
    if(kbhit()!=0) c=getch();
    gotoxy(1,1);
    DrawLights(lights[i*2]%256);
    outp(ADDRESS,lights[i*2]);
    gotoxy(1,1);
    delay(lights[i*2+1]*FAKT);
    i++;
    i=i%elements;
   }
  outp(ADDRESS,0);
 }